//
//  NSDictionary+Utility.h
//  Beplused
//
//  Created by Arslan Ilyas on 27/09/2013.
//  Copyright (c) 2013 Rapidzz. All rights reserved.
//
import UIKit
import Foundation
extension NSDictionary {
    func objectForKeyNotNull(key: AnyObject) -> AnyObject {
        var object = self[key]
        if object == NSNull() {
            return nil
        }
        return object
    }

    func objectForKeyWithEmptyString(key: AnyObject) -> AnyObject {
        var object = self.objectForKeyNotNull(key)
        if object == nil {
            return ""
        }
        return object
    }

    // in case of [NSNull null] values a nil is returned ...
    // if objectForKey returns nil, it will
    // return an empty string.
}
//
//  NSDictionary+Utility.m
//  FishinMobile
//
//  Created by Arslan Ilyas on 27/09/2013.
//  Copyright (c) 2013 Rapidzz. All rights reserved.
//